package parser;

/**
 * Grammar non-terminal -- T ::= num T1
 */
public class T {
    /**
     * Number object.
     */
    private NumToken _num;

    /**
     * T1 object.
     */
    private T1 _t1;

    /**
     * Constructor for the T grammar non-terminal.
     *
     * @param num number object
     * @param t1  T1 object
     */
    public T(NumToken num, T1 t1) {
        _num = num;
        _t1 = t1;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _num.toString() + _t1.toString();
    }
}

